definition module oswindow

from StdString		import String
from StdOverloaded	import ==
from osfont			import Font
from osrgn			import OSRgnHandle
from ostoolbox		import OSToolbox
from intrface		import HWND
from ostypes		import Rect
from ospicture		import OSPictContext

// OSGetProcessWindowDimensions -> return (x,y,w,h) of process windows
OSGetProcessWindowDimensions :: !*OSToolbox -> (!Rect,!*OSToolbox)

::	OSWindowPtr
	:== HWND
OSNoWindowPtr
	:== -1


/*	System dependent constants:
*/
OSControlTitleSpecialChars :== []					// Special prefix characters that should be removed


/*	System dependent metrics:
*/
::	OSWindowMetrics
	=	{	osmFont				:: Font				// The internal Font used in Windows for controls
		,	osmFontMetrics		:: (Int,Int,Int)	// The ascent, descent, leading of osmFont
		,	osmHeight			:: Int				// The height of the internal Font
		,	osmHorMargin		:: Int				// The default horizontal margin
		,	osmVerMargin		:: Int				// The default vertical   margin
		,	osmHorItemSpace		:: Int				// The default horizontal item space
		,	osmVerItemSpace		:: Int				// The default vertical   item space
		,	osmHSliderHeight	:: Int				// The default height of a horizontal slider control
		,	osmVSliderWidth		:: Int				// The default width  of a vertical   slider control
		}

OSDefaultWindowMetrics	:: !*OSToolbox -> (!OSWindowMetrics, !*OSToolbox)
OSMinWindowSize			:: (!Int,!Int)
OSMinCompoundSize		:: (!Int,!Int)

/*	Determine the size of controls:
	OSgetButtonControlSize windowmetrics title
		returns the size of the ButtonControl that has the given title.
	OSgetTextControlSize windowmetrics title
		returns the size of the TextControl   that has the given title.
	OSgetEditControlSize windowmetrics width nr
		returns the size of the EditControl that has the given width and should show nr of lines.
	OSgetPopUpControlSize windowmetrics items
		returns the size of the PopUpControl that thas the given list of items.
	OSget(Radio/Check)ControlItemSize windowmetrics title
		returns the size of the (Radio/Check)ControlItem that has the given title.
	OSget(Radio/Check)ControlItemHeight windowmetrics
		returns the height of an individual (Radio/Check)ControlItem.
	OSgetSliderControlSize windowmetrics isHorizontal length
		returns the correct size of the SliderControl given its direction (True iff Horizontal) and length.
*/
OSgetButtonControlSize		:: !OSWindowMetrics !String		!*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetTextControlSize		:: !OSWindowMetrics !String		!*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetEditControlSize		:: !OSWindowMetrics !Int !Int	!*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetPopUpControlSize		:: !OSWindowMetrics ![String]	!*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetRadioControlItemSize	:: !OSWindowMetrics !String		!*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetRadioControlItemHeight	:: !OSWindowMetrics -> Int
OSgetCheckControlItemSize	:: !OSWindowMetrics !String		!*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetCheckControlItemHeight	:: !OSWindowMetrics -> Int
OSgetSliderControlSize		:: !OSWindowMetrics !Bool !Int -> (!Int,!Int)


/*	Window creation functions.
	OScreateDialog	isModal
					isClosable title pos size
					getcontrolfocus createcontrols updatecontrols controlinfo
					creates a dialog with the given title, position and size. 
					The isModal		argument is True iff the dialog is modal.
	OScreateWindow	isResizable hScrollInfo vScrollInfo minSize maxSize
					isClosable title pos size
					getcontrolfocus createcontrols updatecontrols controlinfo
					creates a window with the given title, position and size. 
					The isResizable	argument is True iff the window is user resizable.
					The hScrollInfo	argument represents the horizontal scrollbar of the window.
					The vScrollInfo	argument represents the vertical   scrollbar of the window.
					The minSize		argument is the minimum size of the window.
					The maxSize		argument is the maximum size of the window.
					The return OSWindowPtrs (result 3,4) are the OSWindowPtrs of the scrollbars.
	The isClosable		argument is True iff the window/dialog is user closeable.
	The title			argument is the title of the window/dialog.
	The pos				argument is the position of the window/dialog.
	The size			argument is the size of the window/dialog.
	The getcontrolfocus	argument function returns the handle to the control that 
						has the input focus.
	The createcontrols	argument function creates the controls of the window/dialog, 
						given the handle to the created window/dialog and the proper control information.
	The updatecontrols	argument function updates the customised controls of the window/dialog.
	The return [DelayActivationInfo] are the OSWindowPtrs of windows/dialogs that have become (in)active (in that order).
	The return  OSWindowPtr is the OSWindowPtr of the created window/dialog.
*/
::	DelayActivationInfo						// ActivationInfo states whether the window
	=	DelayActivated		OSWindowPtr		// has become active or
	|	DelayDeactivated	OSWindowPtr		// has become inactive

OScreateDialog :: !Bool
				  !Bool !String !(!Int,!Int) !(!Int,!Int)
				  !(.s->(OSWindowPtr,.s))
				  !(OSWindowPtr-> .s -> *OSToolbox -> (.s,*OSToolbox))
				  !(OSWindowPtr->OSWindowPtr->OSPictContext->.s->*OSToolbox->(.s,*OSToolbox))
				  !.s !*OSToolbox
			   -> (![DelayActivationInfo],!OSWindowPtr,!.s,!*OSToolbox)
OScreateWindow :: !Bool !ScrollbarInfo !ScrollbarInfo !(!Int,!Int) !(!Int,!Int)
				  !Bool !String !(!Int,!Int) !(!Int,!Int)
				  !(.s->(OSWindowPtr,.s))
				  !(OSWindowPtr-> .s -> *OSToolbox -> (.s,*OSToolbox))
				  !(OSWindowPtr->OSWindowPtr->OSPictContext->.s->*OSToolbox->(.s,*OSToolbox))
				  !.s !*OSToolbox
			   -> (![DelayActivationInfo],!OSWindowPtr,!OSWindowPtr,!OSWindowPtr,!.s,!*OSToolbox)

/*	Control creation functions:
	OScreateRadioControl parentWindow parentPos title able pos size selected isfirst
		creates a RadioControl in the window identified by parentWindow. 
	OScreateCheckControl parentWindow parentPos title able pos size selected isfirst
		creates a CheckControl in the window identified by parentWindow.
	OScreateEmptyPopUpControl parentWindow parentPos able pos nrItems
		creates an initially empty PopUpControl that will display nrItems elements.
	OScreatePopUpControlItem parentPopUp able title selected
		appends an item title to the parentPopUp PopUpControl. The return Int is its zero based index.
	OScreateSliderControl parentWindow parentPos show able horizontal pos size range
		creates a horizontal (True) or vertical (False) SliderControl in the window identified by parentWindow.
	OScreateTextControl parentWindow parentPos text pos size
		creates a TextControl in the window identified by parentWindow.
	OScreateEditControl parentWindow parentPos text able isKeySensitive pos size
		creates an EditControl in the window identified by parentWindow.
	OScreateButtonControl parentWindow parentPos title able pos size isdefaultbutton
		creates a ButtonControl in the window identified by parentWindow.
	OScreateCustomButtonControl parentWindow parentPos able pos size isdefaultbutton
		creates a CustomButtonControl in the window identified by parentWindow.
	OScreateCustomControl parentWindow parentPos able pos size 
		creates a CustomControl in the window identified by parentWindow.
	OScreateCompoundControl parentWindow parentPos show able pos size hScrollInfo vScrollInfo
		creates a CompoundControl in the window identified by parentWindow.
*/
OScreateRadioControl		:: !OSWindowPtr !(!Int,!Int) !String !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Bool !Bool !*OSToolbox
																					 -> (!OSWindowPtr,!*OSToolbox)
OScreateCheckControl		:: !OSWindowPtr !(!Int,!Int) !String !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Bool !Bool !*OSToolbox
																					 -> (!OSWindowPtr,!*OSToolbox)
OScreateEmptyPopUpControl	:: !OSWindowPtr !(!Int,!Int) !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Int !*OSToolbox
																	  -> (!OSWindowPtr,!*OSToolbox)
OScreatePopUpControlItem	:: !OSWindowPtr !Bool !String !Bool !*OSToolbox -> (!Int,!*OSToolbox)
OScreateSliderControl		:: !OSWindowPtr !(!Int,!Int) !Bool !Bool !Bool !(!Int,!Int) !(!Int,!Int) !(!Int,!Int,!Int,!Int) !*OSToolbox
																										   -> (!OSWindowPtr,!*OSToolbox)
OScreateTextControl			:: !OSWindowPtr !(!Int,!Int) !String !Bool !(!Int,!Int) !(!Int,!Int) !*OSToolbox
																   -> (!OSWindowPtr,!*OSToolbox)
OScreateEditControl			:: !OSWindowPtr !(!Int,!Int) !String !Bool !Bool !Bool !(!Int,!Int) !(!Int,!Int) !*OSToolbox
																							-> (!OSWindowPtr,!*OSToolbox)
OScreateButtonControl		:: !OSWindowPtr !(!Int,!Int) !String !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Bool !*OSToolbox
																			   -> (!OSWindowPtr,!*OSToolbox)
OScreateCustomButtonControl	:: !OSWindowPtr !(!Int,!Int) !Bool !Bool !(!Int,!Int) !(!Int,!Int) !Bool !*OSToolbox
																	   -> (!OSWindowPtr,!*OSToolbox)
OScreateCustomControl		:: !OSWindowPtr !(!Int,!Int) !Bool !Bool !(!Int,!Int) !(!Int,!Int) !*OSToolbox
																 -> (!OSWindowPtr,!*OSToolbox)

::	ScrollbarInfo
	=	{	cbiHasScroll	:: !Bool				// The scrollbar exists
		,	cbiPos			:: (Int,Int)			// Its position within the parent
		,	cbiSize			:: (Int,Int)			// Its size within the parent
		,	cbiState		:: (Int,Int,Int,Int)	// Its (min,thumb,max,thumbsize) settings
		}

OScreateCompoundControl		:: !OSWindowPtr !(!Int,!Int) !Bool !Bool !(!Int,!Int) !(!Int,!Int) !ScrollbarInfo !ScrollbarInfo
																						!*OSToolbox
											 -> (!OSWindowPtr,!OSWindowPtr,!OSWindowPtr,!*OSToolbox)


/*	Window destruction operations.
	OSdestroyWindow isModal window
		destroys the window identified by window. The Boolean isModal is True iff the window is Modal.
		The first  return [OSWindowPtr] is the list of activated windows.
		The second return [OSWindowPtr] is the list of deactivated windows.
*/
OSdestroyWindow	:: !Bool !OSWindowPtr !*OSToolbox -> (![OSWindowPtr],![OSWindowPtr],!*OSToolbox)


/*	Control destruction operations.
*/
OSdestroyRadioControl		:: !OSWindowPtr	!*OSToolbox -> *OSToolbox
OSdestroyCheckControl		:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyPopUpControl		:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroySliderControl		:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyTextControl		:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyEditControl		:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyButtonControl		:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyCustomButtonControl:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyCustomControl		:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSdestroyCompoundControl	:: !OSWindowPtr !*OSToolbox -> *OSToolbox


/*	Control update operations.
	OSupdateRadioControl	area parentWindow theControl updates the area of theControl in parentWindow
	OSupdateCheckControl	area parentWindow theControl updates the area of theControl in parentWindow
	OSupdatePopUpControl	area parentWindow theControl updates the area of theControl in parentWindow
	OSupdateSliderControl	area parentWindow theControl updates the area of theControl in parentWindow
	OSupdateTextControl		area parentWindow theControl updates the area of theControl in parentWindow
	OSupdateEditControl		area parentWindow theControl updates the area of theControl in parentWindow
	OSupdateButtonControl	area parentWindow theControl updates the area of theControl in parentWindow
*/
OSupdateRadioControl		:: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateCheckControl		:: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdatePopUpControl		:: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateSliderControl		:: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateTextControl			:: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateEditControl			:: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox
OSupdateButtonControl		:: !Rect !OSWindowPtr !OSWindowPtr !*OSToolbox -> *OSToolbox


/*	Control clipping operations.
	OSclipRadioControl        parentWindow parentPos area pos size generates the clipping region of a radio control within area.
	OSclipCheckControl        parentWindow parentPos area pos size generates the clipping region of a check control within area.
	OSclipPopUpControl        parentWindow parentPos area pos size generates the clipping region of a pop up control within area.
	OSclipSliderControl       parentWindow parentPos area pos size generates the clipping region of a slider control within area.
	OSclipTextControl         parentWindow parentPos area pos size generates the clipping region of a text control within area.
	OSclipEditControl         parentWindow parentPos area pos size generates the clipping region of a edit control within area.
	OSclipButtonControl       parentWindow parentPos area pos size generates the clipping region of a button control within area.
	OSclipCustomButtonControl parentWindow parentPos area pos size generates the clipping region of a custom button control within area.
	OSclipCustomControl       parentWindow parentPos area pos size generates the clipping region of a custom control within area.
	OSclipCompoundControl     parentWindow parentPos area pos size generates the clipping region of a compound control within area.
*/
OSclipRadioControl			:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipCheckControl			:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipPopUpControl			:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipSliderControl			:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipTextControl			:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipEditControl			:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipButtonControl			:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipCustomButtonControl	:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipCustomControl			:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
OSclipCompoundControl		:: !OSWindowPtr !(!Int,!Int) !Rect !(!Int,!Int) !(!Int,!Int) !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)


/*	Window graphics context access operations.
	OSgrabWindowPictContext theWindow
		returns the graphics context that must be used to update the window.
	OSreleaseWindowPictContext theWindow theContext
		releases the graphics context.
	OSgrabControlPictContext theWindow theControl
		returns the graphics context that must be used to update the control.
	OSreleaseControlPictContext theControl theContext
		releases the graphics context.
*/
OSgrabWindowPictContext		:: !OSWindowPtr					!*OSToolbox -> (!OSPictContext,!*OSToolbox)
OSgrabControlPictContext	:: !OSWindowPtr !OSWindowPtr	!*OSToolbox -> (!OSPictContext,!*OSToolbox)
OSreleaseWindowPictContext	:: !OSWindowPtr !OSPictContext	!*OSToolbox -> *OSToolbox
OSreleaseControlPictContext :: !OSWindowPtr !OSPictContext	!*OSToolbox -> *OSToolbox


/*	Scrollbar operations.
*/

/*	toOSscrollbarRange (domainMin,viewMin,domainMax) viewSize
		maps the (domainMin,viewMin,domainMax) viewSize values to proper OS values (osRangeMin,osThumb,osRangeMax,osThumbSize).
	fromOSscrollbarRange (domainMin,domainMax) viewSize osThumb
		maps the osThumb value between the (domainMin,domainMax) values.
	These values are also valid for CompoundControls.
	Both functions assume that:domainMin<=viewMin<= domainMax 
						  and osRangeMin<=osThumb<=osRangeMax.
	OSscrollbarIsVisible (domainMin,domainMax) viewSize
		determines whether the scrollbar is visible given these settings.
	OSscrollbarsAreVisible wMetrics windowDomain size (hasHScroll,hasVScroll)
		determines the visibility of the horizontal/vertical scrollbars given the domain, size, and presence.
*/
toOSscrollbarRange		:: !(!Int,!Int,!Int) !Int -> (!Int,!Int,!Int,!Int)
fromOSscrollbarRange	:: !(!Int,!Int) !Int !Int -> Int
OSscrollbarIsVisible	:: !(!Int,!Int) !Int -> Bool
OSscrollbarsAreVisible	:: !OSWindowMetrics !(!Int,!Int,!Int,!Int) !(!Int,!Int) !(!Bool,!Bool) -> (!Bool,!Bool)


/*	Window access operations.
*/

/*	OSsetWindowSliderThumb theWindow isHorizontal thumb redraw
		sets the thumb value of the horizontal/vertical slider of the given window.
	OSsetWindowSliderThumbSize theWindow isHorizontal size redraw
		sets the view size of the horizontal/vertical slider of the given window.
	OSsetWindowSlider theWindow isHorizontal (osRangeMin,osThumb,osRangeMax,osThumbSize)
		sets all values of the horizontal/vertical slider of the given window.
*/
OSsetWindowSliderThumb		:: !OSWindowPtr !Bool !Int !Bool !*OSToolbox -> *OSToolbox
OSsetWindowSliderThumbSize	:: !OSWindowPtr !Bool !Int !Bool !*OSToolbox -> *OSToolbox
OSsetWindowSlider			:: !OSWindowPtr !Bool !(!Int,!Int,!Int,!Int) !*OSToolbox -> *OSToolbox


/*	OSinvalidateWindow theWindow
		invalidates the window identified by theWindow, forcing an update event for the entire contents.
	OSinvalidateWindowRect theWindow part
		invalidates the part of the window identified by theWindow, forcing an update event for that part.
*/
OSinvalidateWindow		:: !OSWindowPtr			!*OSToolbox -> *OSToolbox
OSinvalidateWindowRect	:: !OSWindowPtr !Rect	!*OSToolbox -> *OSToolbox

/*	OS(dis/en)ableWindow theWindow
		(dis/en)able the window identified by theWindow.
		The Boolean tuple indicates whether the window has a horizontal/vertical scrollbar.
		The last Boolean argument indicates whether the window is (dis/en)abled because of a modal dialogue.
*/
OSdisableWindow			:: !OSWindowPtr !(!Bool,!Bool) !Bool !*OSToolbox -> *OSToolbox
OSenableWindow			:: !OSWindowPtr !(!Bool,!Bool) !Bool !*OSToolbox -> *OSToolbox

/*	OSactivateWindow thisWindow
		activates the window.
	OSstackWindow thisWindow behindWindow
		moves the window identified by thisWindow behind the window identified by behindWindow.
		OSstackWindow assumes that thisWindow and behindWindow are valid values.
*/
OSactivateWindow:: !OSWindowPtr					!*OSToolbox -> *OSToolbox
OSstackWindow	:: !OSWindowPtr !OSWindowPtr	!*OSToolbox -> *OSToolbox

/*	OShideWindow thisWindow hides the window.
	OSshowWindow thisWindow activate show the window. If the Boolean activate is True then the
				 window is also made the active window. If the Boolean activate is False then the
				 stacking order is not changed.
*/
OShideWindow	:: !OSWindowPtr !*OSToolbox -> *OSToolbox
OSshowWindow	:: !OSWindowPtr !Bool !*OSToolbox -> *OSToolbox

/*	OSgetWindowPos  returns the current position of the window.
	OSgetWindowSize returns the current size of the window.
	OSsetWindowPos  sets the position of the window.
	OSsetWindowSize sets the size of the window.
*/
OSgetWindowPos	:: !OSWindowPtr !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSgetWindowSize	:: !OSWindowPtr !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)
OSsetWindowPos	:: !OSWindowPtr !(!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetWindowSize	:: !OSWindowPtr !(!Int,!Int) !*OSToolbox -> *OSToolbox

/*	OSsetWindowTitle sets the title of the window.
*/
OSsetWindowTitle:: !OSWindowPtr !String !*OSToolbox -> *OSToolbox


/*	Control access operations.
*/

/*	On compound controls:
	OSinvalidateCompound compoundPtr
		invalidates the compound control, forcing an update event for the entire contents.
	OSinvalidateCompoundRect compoundPtr part
		invalidates the part of the compound control, forcing an update event for that part.
	OSsetCompoundSliderThumb compoundPtr isHorizontal thumb redraw
		sets the thumb value of the horizontal/vertical slider of the given compound control.
	OSsetCompoundSliderThumbSize compoundPtr isHorizontal size redraw
		sets the view size of the horizontal/vertical slider of the given compound control.
	OSsetCompoundSlider compoundPtr isHorizontal (osRangeMin,osThumb,osRangeMax,osThumbSize)
		sets all slider values of the horizontal/vertical slider of the given compound control.
	OSsetCompoundSelect parentWindow compoundPtr clipRect (hasHScroll,hasVScroll) toAble
		enables the compound control (if toAble), or disables the compound control (if (not toAble)), while clipping.
	OSsetCompoundShow parentWindow compoundPtr clipRect show
		shows the compound control (if show), or hides the compound control (if (not show)), while clipping.
	OSsetCompoundPos parentWindow parentPos compoundPtr pos size
		sets the new position of the compound control. 
		If the Boolean result is True, then the elements of the compound control should also be moved.
		If the Boolean result is False,then the elements of the compound control should not  be moved.
	OSsetCompoundSize parentWindow parentPos compoundPtr pos size
		sets the new size of the compound control.
*/
OSinvalidateCompound			:: !OSWindowPtr														!*OSToolbox -> *OSToolbox
OSinvalidateCompoundRect		:: !OSWindowPtr !Rect												!*OSToolbox -> *OSToolbox
OSsetCompoundSliderThumb		:: !OSWindowPtr !Bool !Int !Bool									!*OSToolbox -> *OSToolbox
OSsetCompoundSliderThumbSize	:: !OSWindowPtr !Bool !Int !Bool									!*OSToolbox -> *OSToolbox
OSsetCompoundSlider				:: !OSWindowPtr !Bool !(!Int,!Int,!Int,!Int)						!*OSToolbox -> *OSToolbox
OSsetCompoundSelect				:: !OSWindowPtr !OSWindowPtr !Rect !(!Bool,!Bool) !Bool				!*OSToolbox -> *OSToolbox
OSsetCompoundShow				:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetCompoundPos				:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> (!Bool,!*OSToolbox)
OSsetCompoundSize				:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox

/*	On slider controls:
	OSsetSliderThumb parentWindow sliderPtr clipRect redraw (min,thumb,max)
		sets the thumb value of the slider control, while clipping.
	OSsetSliderControlSelect parentWindow sliderPtr clipRect toAble
		enables the slider control (if toAble), or disables the slider control (if (not toAble)), while clipping.
	OSsetSliderControlShow parentWindow sliderPtr clipRect show
		shows the slider control (if show), or hides the slider control (if (not show)), while clipping.
	OSsetSliderControlPos parentWindow parentPos sliderPtr pos size
		sets the new position of the slider control.
	OSsetSliderControlSize parentWindow parentPos sliderPtr pos size 
		sets the new size of the slider control.
*/
OSsetSliderThumb				:: !OSWindowPtr !OSWindowPtr !Rect !Bool !(!Int,!Int,!Int)				!*OSToolbox -> *OSToolbox
OSsetSliderControlSelect		:: !OSWindowPtr !OSWindowPtr !Rect !Bool								!*OSToolbox -> *OSToolbox
OSsetSliderControlShow			:: !OSWindowPtr !OSWindowPtr !Rect !Bool								!*OSToolbox -> *OSToolbox
OSsetSliderControlPos			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)		!*OSToolbox -> *OSToolbox
OSsetSliderControlSize			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)		!*OSToolbox -> *OSToolbox

/*	On radio controls:
	OSsetRadioControl parentWindow current new clipRect
		removes the selection from current and sets the selection to new, while clipping.
	OSsetRadioControlSelect parentWindow radioPtr clipRect toAble
		enables the radio control (if toAble), or disables the radio control (if (not toAble)), while clipping.
	OSsetRadioControlShow parentWindow radioPtr clipRect show
		shows the radio control (if show), or hides the radio control (if (not show)), while clipping.
	OSsetRadioControlPos parentWindow parentPos radioPtr pos size
		sets the new position of the radio control.
	OSsetRadioControlSize parentWindow parentPos radioPtr pos size
		sets the new size of the radio control.
*/
OSsetRadioControl				:: !OSWindowPtr !OSWindowPtr !OSWindowPtr !Rect						!*OSToolbox -> *OSToolbox
OSsetRadioControlSelect			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetRadioControlShow			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetRadioControlPos			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
OSsetRadioControlSize			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox

/*	On check controls:
	OSsetCheckControl parentWindow checkPtr clipRect marked
		sets the check mark (if marked) or removes the check mark (if not marked) of the check control, while clipping.
	OSsetCheckControlSelect parentWindow checkPtr clipRect toAble
		enables the check control (if toAble), or disables the check control (if (not toAble)), while clipping.
	OSsetCheckControlShow parentWindow checkPtr clipRect show
		shows the check control (if show), or hides the check control (if (not show)), while clipping.
	OSsetCheckControlPos parentWindow parentPos checkPtr pos size
		sets the new position of the check control.
	OSsetCheckControlSize parentWindow parentPos checkPtr pos size
		sets the new size of the check control.
*/
OSsetCheckControl				:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetCheckControlSelect			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetCheckControlShow			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetCheckControlPos			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
OSsetCheckControlSize			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox

/*	On pop up controls:
	OSsetPopUpControl parentWindow popupPtr clipRect current new newtext shown
		removes the selection from current and sets the selection to new, while clipping. Both indices are zero based!
	OSsetPopUpControlSelect parentWindow popupPtr clipRect toAble
		enables the pop up control (if toAble), or disables the pop up control (if (not toAble)), while clipping.
	OSsetPopUpControlShow parentWindow popupPtr clipRect show
		shows the pop up control (if show), or hides the pop up control (if (not show)), while clipping.
	OSsetPopUpControlPos parentWindow parentPos popupPtr pos size
		sets the new position of the pop up control.
	OSsetPopUpControlSize parentWindow parentPos popupPtr pos size
		sets the new size of the pop up control.
*/
OSsetPopUpControl				:: !OSWindowPtr !OSWindowPtr !Rect !Rect !Int !Int !String !Bool	!*OSToolbox -> *OSToolbox
OSsetPopUpControlSelect			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetPopUpControlShow			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetPopUpControlPos			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
OSsetPopUpControlSize			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox

/*	On edit controls:
	OSsetEditControlText parentWindow editPtr clipRect itemRect shown text 
		sets the text of the shown edit control while clipping.
	OSgetEditControlText parentWindow editPtr 
		returns the current content of the edit control.
	OSsetEditControlCursor parentWindow editPtr clipRect itemRect pos
		sets the cursor position at pos of the edit control while clipping.
	OSsetEditControlSelect parentWindow editPtr clipRect toAble
		enables the edit control (if toAble), or disables the edit control (if (not toAble)), while clipping.
	OSsetEditControlShow parentWindow editPtr clipRect show
		shows the edit control (if show), or hides the edit control (if (not show)), while clipping.
	OSsetEditControlPos parentWindow parentPos editPtr pos size
		sets the new position of the edit control.
	OSsetEditControlSize parentWindow parentPos editPtr pos size
		sets the new size of the edit control.
*/
OSsetEditControlText			:: !OSWindowPtr !OSWindowPtr !Rect !Rect !Bool !String				!*OSToolbox -> *OSToolbox
OSgetEditControlText			:: !OSWindowPtr !OSWindowPtr										!*OSToolbox -> (!String,!*OSToolbox) 
OSsetEditControlCursor			:: !OSWindowPtr !OSWindowPtr !Rect !Rect !Int						!*OSToolbox -> *OSToolbox
OSsetEditControlSelect			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetEditControlShow			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetEditControlPos				:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
OSsetEditControlSize			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox

/*	On text controls:
	OSsetTextControlText parentWindow textPtr clipRect itemRect shown text
		sets the text of the shown edit control while clipping.
	OSsetTextControlSelect parentWindow textPtr clipRect toAble
		enables the text control (if toAble), or disables the text control (if (not toAble)), while clipping.
	OSsetTextControlShow parentWindow textPtr clipRect show
		shows the text control (if show), or hides the text control (if (not show)), while clipping.
	OSsetTextControlPos parentWindow parentPos textPtr pos size
		sets the new position of the text control.
	OSsetTextControlSize parentWindow parentPos textPtr pos size
		sets the new size of the text control.
*/
OSsetTextControlText			:: !OSWindowPtr !OSWindowPtr !Rect !Rect !Bool !String				!*OSToolbox -> *OSToolbox
OSsetTextControlSelect			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetTextControlShow			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetTextControlPos				:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
OSsetTextControlSize			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox

/*	On button controls:
	OSsetButtonControlText parentWindow buttonPtr clipRect text
		sets the text of the button control while clipping.
	OSsetButtonControlSelect parentWindow buttonPtr clipRect toAble
		enables the button control (if toAble), or disables the button control (if (not toAble)), while clipping.
	OSsetButtonControlShow parentWindow buttonPtr clipRect show
		shows the button control (if show), or hides the button control (if (not show)), while clipping.
	OSsetButtonControlPos parentWindow parentPos buttonPtr pos size
		sets the new position of the button control.
	OSsetButtonControlSize parentWindow parentPos buttonPtr pos size
		sets the new size of the button control.
*/
OSsetButtonControlText			:: !OSWindowPtr !OSWindowPtr !Rect !String							!*OSToolbox -> *OSToolbox
OSsetButtonControlSelect		:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetButtonControlShow			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetButtonControlPos			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
OSsetButtonControlSize			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox

/*	On custom button controls:
	OSsetCustomButtonControlSelect parentWindow buttonPtr clipRect toAble
		enables the custom button control (if toAble), or disables the custom button control (if (not toAble)), while clipping.
	OSsetCustomButtonControlShow parentWindow buttonPtr clipRect show
		shows the custom button control (if show), or hides the custom button control (if (not show)), while clipping.
	OSsetCustomButtonControlPos parentWindow parentPos buttonPtr pos size
		sets the new position of the custom button control.
	OSsetCustomButtonControlSize parentWindow parentPos buttonPtr pos size
		sets the new size of the custom button control.
*/
OSsetCustomButtonControlSelect	:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetCustomButtonControlShow	:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetCustomButtonControlPos		:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
OSsetCustomButtonControlSize	:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox

/*	On custom controls:
	OSsetCustomControlSelect parentWindow controlPtr clipRect toAble
		enables the custom control (if toAble), or disables the custom control (if (not toAble)), while clipping.
	OSsetCustomControlShow parentWindow controlPtr clipRect show
		shows the custom control (if show), or hides the custom control (if (not show)), while clipping.
	OSsetCustomControlPos parentWindow parentPos controlPtr pos size
		sets the new position of the custom control
	OSsetCustomControlSize parentWindow parentPos controlPtr pos size
		sets the new size of the custom control.
*/
OSsetCustomControlSelect		:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetCustomControlShow			:: !OSWindowPtr !OSWindowPtr !Rect !Bool							!*OSToolbox -> *OSToolbox
OSsetCustomControlPos			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
OSsetCustomControlSize			:: !OSWindowPtr !(!Int,!Int) !OSWindowPtr !(!Int,!Int) !(!Int,!Int)	!*OSToolbox -> *OSToolbox
